﻿// YXDataSDK
export default class YXDataSDK {
    private static configs = {
        request_key: "c6105d34ec6aeefe179a062cba1f2fa9",
        request_url: "https://report.yongxiandata.com/",
        init_path: "sdk_init",
        report_path: "auth/report",
        location_path: "user/location",
        access_token: "",
    };

    private static initParams = {
        sdk_version: "ts_202411011",//sdk版本
        game_id: 0,
        event_name: "",
        channel: "",
        device_id: "",
        device_model: "",//设备型号，用户设备的型号，如 iPhone 8 等
        screen_height: 0,//屏幕高度
        screen_width: 0,//屏幕宽度
        os_version: "",//操作系统版本,iOS 11.2.2、Android 8.0.0 等
        os: "",//操作系统,如 Android、iOS 等
        scene: "",//场景值，微信小游戏启动时传入的场景值
        app_version: "",
        network_type: "",
        install_time: "",
        simulator: "",
        ram: "",
        disk: "",
        manufacturer: "",
        client_time: 0,
        account_id: "",
        properties: {},
        zone_offset: 0,    
        app_server: "",
    };

    private static superProperties = {first_event:0};

    public static init(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.setArgs(params);
    }
    public static eventReport(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.dataReport(params);
    }
    public static login(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.loginReport(params);
    }
    public static setAccountProperty(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.addAccountProperty(params);
    }
    public static setAccountOnce(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.addAccountOnce(params);
    }
    public static changeAccountProperty(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.updateAccountProperty(params);
    }
    public static setSuperProperties(params) {
        YXDataSDK.superProperties.first_event = 0;
        YXDataSDK.superProperties = {...YXDataSDK.superProperties,...params};
    }
    public static eventFirst(params) {
        YXDataSDK.superProperties.first_event = 1;
        YXDataSDK.dataReport(params);
    }

    private static setArgs(args) {
        if (args != undefined) {
            if (typeof (args) == 'object' && Object.prototype.toString.call(args).toLowerCase() == '[object object]' && !args.length) {
                for (var key in args) {
                    YXDataSDK.initParams[key] = args[key];
                };
            };
        };
        if (args.report_server == 1) {//test-server
            this.configs.request_url = "https://test.hhhoo.com/logsdata/";
            YXDataSDK.configs.request_key = "0ab8f54824ee9dc0461d71ef2b08263e";
        } else if (args.report_server == 2) {//hw-server
            YXDataSDK.configs.request_url = "https://5ghwlog.tygms.com/";
            YXDataSDK.configs.request_key = "f19ba5794800d3938bcd7927b380b66e";
        }
        YXDataSDK.initReport("","");
    };
    private static initReport(callback,cbParams) {
        if (YXDataSDK.initParams.game_id <= 0) {
            console.log("YXDataSDK init game_id is error! game_id:" + YXDataSDK.initParams.game_id);
            return;
        }
        if (YXDataSDK.initParams.channel.length <= 0) {
            console.log("YXDataSDK init channel is error! channel:" + YXDataSDK.initParams.channel);
            return;
        }
        if (YXDataSDK.initParams.device_id.length <= 0) {
            console.log("YXDataSDK init device_id is error! device_id:" + YXDataSDK.initParams.device_id);
            return;
        }
        YXDataSDK.initParams.event_name = "init";
        YXDataSDK.initParams.properties = {...YXDataSDK.initParams.properties,...YXDataSDK.superProperties};
        YXDataSDK.initParams.client_time = Date.now();
        if (this.initParams.account_id.length > 0 && this.initParams.app_server.length > 0) {
            this.initParams.account_id += "-" + this.initParams.app_server;
        }
        YXDataSDK.sendRequest(YXDataSDK.initParams,callback,cbParams);
    } 
    private static dataReport(params) {
        if (!params.hasOwnProperty("client_time")) {
            params.client_time = Date.now();
        }
        if (params.event_name != YXDataSDK.accountProperty.event_name){
            params.properties = {...params.properties,...YXDataSDK.superProperties};
        }
        if (YXDataSDK.configs.access_token.length <= 0) {
            YXDataSDK.initReport(YXDataSDK.dataReport,params);
        } else {
            if (this.initParams.account_id.length > 0) {
                params.account_id = this.initParams.account_id;
            }
            YXDataSDK.sendRequest(params,"","");
        }
    }
    /*****************************login->user********************************/
    private static accountProperty: {
        event_name: string,
        properties: {
            oper_type: number,
            param_name?: string,
            param_type?: number,
            param_value?: string,
            add_sub?: number,
        }
    }={
        event_name: "BI_ACCOUNT_PROPERTY",
        properties: {
            oper_type: 0,
        },
    };
    private static loginReport(params) {
        YXDataSDK.initParams.account_id = params.account_id;
        if (YXDataSDK.initParams.account_id.length > 0) {
            YXDataSDK.initReport(YXDataSDK.dataReport,YXDataSDK.accountProperty);
        }
    }
    private static addAccountProperty(params) {
        YXDataSDK.accountProperty.properties.oper_type = 1;
        YXDataSDK.accountProperty.properties.param_name = params.param_name;
        YXDataSDK.accountProperty.properties.param_type = params.param_type;
        YXDataSDK.accountProperty.properties.param_value = params.param_value;
        YXDataSDK.dataReport(YXDataSDK.accountProperty);
    }
    private static updateAccountProperty(params) {
        YXDataSDK.accountProperty.properties.oper_type = 2;
        YXDataSDK.accountProperty.properties.param_name = params.param_name;
        YXDataSDK.accountProperty.properties.param_type = params.param_type;
        YXDataSDK.accountProperty.properties.param_value = params.param_value;
        YXDataSDK.accountProperty.properties.add_sub = params.add_sub;
        YXDataSDK.dataReport(YXDataSDK.accountProperty);
    }
    private static addAccountOnce(params) {
        YXDataSDK.accountProperty.properties.oper_type = 3;
        YXDataSDK.accountProperty.properties.param_name = params.param_name;
        YXDataSDK.accountProperty.properties.param_type = params.param_type;
        YXDataSDK.accountProperty.properties.param_value = params.param_value;
        YXDataSDK.dataReport(YXDataSDK.accountProperty);
    }

     /*****************************device->online********************************/
     private static onlineProperty = {
        game_id: 0,
        channel: "",
        device_id: "",
        guid: 0,
        user_location: "default",
        client_time: 0,
        sign: "",
    };

    private static setLocation(params){
        YXDataSDK.onlineProperty.guid = params.guid;
        YXDataSDK.onlineProperty.user_location = params.user_location;
    }

    private static onlineReport(){
        if (YXDataSDK.onlineProperty.game_id == 0) {
            YXDataSDK.onlineProperty.game_id = YXDataSDK.initParams.game_id;
            YXDataSDK.onlineProperty.channel = YXDataSDK.initParams.channel;
            YXDataSDK.onlineProperty.device_id = YXDataSDK.initParams.device_id;
        }
        YXDataSDK.onlineProperty.client_time = Date.now();;
        YXDataSDK.onlineProperty.sign = YXDataSDK.getSign(YXDataSDK.onlineProperty.game_id + 
            YXDataSDK.onlineProperty.channel + 
            YXDataSDK.onlineProperty.device_id + 
            YXDataSDK.onlineProperty.guid + 
            YXDataSDK.onlineProperty.user_location);
        let data_json = JSON.stringify(YXDataSDK.onlineProperty);
        let xhr = new XMLHttpRequest();
        xhr.open("post", YXDataSDK.configs.request_url + YXDataSDK.configs.location_path);
        xhr.setRequestHeader("Content-type", "text/plain;charset=utf-8");
        xhr.send(data_json);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status == 200) {
                    var result = JSON.parse(xhr.responseText);
                    if (result.RES == 0) {
                        console.log("onlineReport success!");
                        //setTimeout(YXDataSDK.onlineReport, 3 * 60 * 1000);
                    } else {
                        console.log("onlineReport err:" + result.ERR);
                    }
                }
            }
        };
    }

    /*****************************send********************************/
    private static sendRequest(data,callback,cbParams){
        const self = this;
        data.zone_offset = YXDataSDK.zoneOffset();
        let sign = "";
        let request_cofig = {
            request_url_patch: YXDataSDK.configs.request_url + YXDataSDK.configs.init_path,
            authorization: "BEARER",
        };
        if (data.event_name == "init") {
            sign = YXDataSDK.getSign(data.game_id + data.channel + data.device_id + data.event_name + data.client_time);
        } else {
            sign = YXDataSDK.getSign(data.event_name + data.client_time);
            request_cofig.request_url_patch = YXDataSDK.configs.request_url + YXDataSDK.configs.report_path;
            request_cofig.authorization = request_cofig.authorization + YXDataSDK.configs.access_token;
        }
        data.sign = sign;
        let data_json = JSON.stringify(data);
        let xhr = new XMLHttpRequest();
        xhr.open("post", request_cofig.request_url_patch);
        xhr.setRequestHeader("Content-type", "text/plain;charset=utf-8");
        if (data.event_name !== "init") {
            xhr.setRequestHeader("Authorization", request_cofig.authorization);
        }
        xhr.send(data_json);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status == 200) {
                    var result = JSON.parse(xhr.responseText);
                    if (result.RES == 0) {
                        console.log("report success! event_name:" + data.event_name);
                        if (data.event_name == "init") {
                            YXDataSDK.configs.access_token = result.MSG;
                            if (typeof callback === 'function') {
                                callback.call(self,cbParams);
                            }
                        }
                    } else {
                        console.log("report err:" + result.ERR);
                    }
                }
            }
        };
    }

    /*************************************************************/
    private static getSign(str) {
        str += YXDataSDK.configs.request_key;
        return YXDataSDK.hashStr(str);
    }

    private static zoneOffset(){
        const now = new Date();
        let zoneOff = now.getTimezoneOffset();
        return zoneOff / -60;
    }
    
    /*********************************MD5****************************/
    private static hashStr(str: string, raw?: false): string;
    private static hashStr(str: string, raw: true): Int32Array;
    private static hashStr(str: string, raw: boolean = false) {
        return this.onePassHasher
            .start()
            .appendStr(str)
            .end(raw);
    }
    private static hashAsciiStr(str: string, raw?: false): string;
    private static hashAsciiStr(str: string, raw: true): Int32Array;
    private static hashAsciiStr(str: string, raw: boolean = false) {
        return this.onePassHasher
            .start()
            .appendAsciiStr(str)
            .end(raw);
    }
    private static stateIdentity = new Int32Array([1732584193, -271733879, -1732584194, 271733878]);
    private static buffer32Identity = new Int32Array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
    private static hexChars = '0123456789abcdef';
    private static hexOut: string[] = [];
    private static onePassHasher = new YXDataSDK();
    private static _hex(x: Int32Array): string {
        const hc = this.hexChars;
        const ho = this.hexOut;
        let n;
        let offset;
        let j;
        let i;

        for (i = 0; i < 4; i += 1) {
            offset = i * 8;
            n = x[i];
            for (j = 0; j < 8; j += 2) {
                ho[offset + 1 + j] = hc.charAt(n & 0x0F);
                n >>>= 4;
                ho[offset + 0 + j] = hc.charAt(n & 0x0F);
                n >>>= 4;
            }
        }
        return ho.join('');
    }

    private static _md5cycle(x: Int32Array | Uint32Array, k: Int32Array | Uint32Array) {
        let a = x[0];
        let b = x[1];
        let c = x[2];
        let d = x[3];
        // ff()
        a += (b & c | ~b & d) + k[0] - 680876936 | 0;
        a = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[1] - 389564586 | 0;
        d = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[2] + 606105819 | 0;
        c = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[3] - 1044525330 | 0;
        b = (b << 22 | b >>> 10) + c | 0;
        a += (b & c | ~b & d) + k[4] - 176418897 | 0;
        a = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[5] + 1200080426 | 0;
        d = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[6] - 1473231341 | 0;
        c = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[7] - 45705983 | 0;
        b = (b << 22 | b >>> 10) + c | 0;
        a += (b & c | ~b & d) + k[8] + 1770035416 | 0;
        a = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[9] - 1958414417 | 0;
        d = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[10] - 42063 | 0;
        c = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[11] - 1990404162 | 0;
        b = (b << 22 | b >>> 10) + c | 0;
        a += (b & c | ~b & d) + k[12] + 1804603682 | 0;
        a = (a << 7 | a >>> 25) + b | 0;
        d += (a & b | ~a & c) + k[13] - 40341101 | 0;
        d = (d << 12 | d >>> 20) + a | 0;
        c += (d & a | ~d & b) + k[14] - 1502002290 | 0;
        c = (c << 17 | c >>> 15) + d | 0;
        b += (c & d | ~c & a) + k[15] + 1236535329 | 0;
        b = (b << 22 | b >>> 10) + c | 0;
        // gg()
        a += (b & d | c & ~d) + k[1] - 165796510 | 0;
        a = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[6] - 1069501632 | 0;
        d = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[11] + 643717713 | 0;
        c = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[0] - 373897302 | 0;
        b = (b << 20 | b >>> 12) + c | 0;
        a += (b & d | c & ~d) + k[5] - 701558691 | 0;
        a = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[10] + 38016083 | 0;
        d = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[15] - 660478335 | 0;
        c = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[4] - 405537848 | 0;
        b = (b << 20 | b >>> 12) + c | 0;
        a += (b & d | c & ~d) + k[9] + 568446438 | 0;
        a = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[14] - 1019803690 | 0;
        d = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[3] - 187363961 | 0;
        c = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[8] + 1163531501 | 0;
        b = (b << 20 | b >>> 12) + c | 0;
        a += (b & d | c & ~d) + k[13] - 1444681467 | 0;
        a = (a << 5 | a >>> 27) + b | 0;
        d += (a & c | b & ~c) + k[2] - 51403784 | 0;
        d = (d << 9 | d >>> 23) + a | 0;
        c += (d & b | a & ~b) + k[7] + 1735328473 | 0;
        c = (c << 14 | c >>> 18) + d | 0;
        b += (c & a | d & ~a) + k[12] - 1926607734 | 0;
        b = (b << 20 | b >>> 12) + c | 0;
        // hh()
        a += (b ^ c ^ d) + k[5] - 378558 | 0;
        a = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[8] - 2022574463 | 0;
        d = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[11] + 1839030562 | 0;
        c = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[14] - 35309556 | 0;
        b = (b << 23 | b >>> 9) + c | 0;
        a += (b ^ c ^ d) + k[1] - 1530992060 | 0;
        a = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[4] + 1272893353 | 0;
        d = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[7] - 155497632 | 0;
        c = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[10] - 1094730640 | 0;
        b = (b << 23 | b >>> 9) + c | 0;
        a += (b ^ c ^ d) + k[13] + 681279174 | 0;
        a = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[0] - 358537222 | 0;
        d = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[3] - 722521979 | 0;
        c = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[6] + 76029189 | 0;
        b = (b << 23 | b >>> 9) + c | 0;
        a += (b ^ c ^ d) + k[9] - 640364487 | 0;
        a = (a << 4 | a >>> 28) + b | 0;
        d += (a ^ b ^ c) + k[12] - 421815835 | 0;
        d = (d << 11 | d >>> 21) + a | 0;
        c += (d ^ a ^ b) + k[15] + 530742520 | 0;
        c = (c << 16 | c >>> 16) + d | 0;
        b += (c ^ d ^ a) + k[2] - 995338651 | 0;
        b = (b << 23 | b >>> 9) + c | 0;
        // ii()
        a += (c ^ (b | ~d)) + k[0] - 198630844 | 0;
        a = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[7] + 1126891415 | 0;
        d = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[14] - 1416354905 | 0;
        c = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[5] - 57434055 | 0;
        b = (b << 21 | b >>> 11) + c | 0;
        a += (c ^ (b | ~d)) + k[12] + 1700485571 | 0;
        a = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[3] - 1894986606 | 0;
        d = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[10] - 1051523 | 0;
        c = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[1] - 2054922799 | 0;
        b = (b << 21 | b >>> 11) + c | 0;
        a += (c ^ (b | ~d)) + k[8] + 1873313359 | 0;
        a = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[15] - 30611744 | 0;
        d = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[6] - 1560198380 | 0;
        c = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[13] + 1309151649 | 0;
        b = (b << 21 | b >>> 11) + c | 0;
        a += (c ^ (b | ~d)) + k[4] - 145523070 | 0;
        a = (a << 6 | a >>> 26) + b | 0;
        d += (b ^ (a | ~c)) + k[11] - 1120210379 | 0;
        d = (d << 10 | d >>> 22) + a | 0;
        c += (a ^ (d | ~b)) + k[2] + 718787259 | 0;
        c = (c << 15 | c >>> 17) + d | 0;
        b += (d ^ (c | ~a)) + k[9] - 343485551 | 0;
        b = (b << 21 | b >>> 11) + c | 0;

        x[0] = a + x[0] | 0;
        x[1] = b + x[1] | 0;
        x[2] = c + x[2] | 0;
        x[3] = d + x[3] | 0;
    }

    private _dataLength = 0;
    private _bufferLength = 0;

    private _state: Int32Array = new Int32Array(4);
    private _buffer: ArrayBuffer = new ArrayBuffer(68);
    private _buffer8: Uint8Array;
    private _buffer32: Uint32Array;

    constructor() {
        this._buffer8 = new Uint8Array(this._buffer, 0, 68);
        this._buffer32 = new Uint32Array(this._buffer, 0, 17);
        this.start();
    }
    private start() {
        this._dataLength = 0;
        this._bufferLength = 0;
        this._state.set(YXDataSDK.stateIdentity);
        return this;
    }
    private appendStr(str: string) {
        const buf8 = this._buffer8;
        const buf32 = this._buffer32;
        let bufLen = this._bufferLength;
        let code;
        let i;

        for (i = 0; i < str.length; i += 1) {
            code = str.charCodeAt(i);
            if (code < 128) {
                buf8[bufLen++] = code;
            } else if (code < 0x800) {
                buf8[bufLen++] = (code >>> 6) + 0xC0;
                buf8[bufLen++] = code & 0x3F | 0x80;
            } else if (code < 0xD800 || code > 0xDBFF) {
                buf8[bufLen++] = (code >>> 12) + 0xE0;
                buf8[bufLen++] = (code >>> 6 & 0x3F) | 0x80;
                buf8[bufLen++] = (code & 0x3F) | 0x80;
            } else {
                code = ((code - 0xD800) * 0x400) + (str.charCodeAt(++i) - 0xDC00) + 0x10000;
                if (code > 0x10FFFF) {
                    throw new Error('Unicode standard supports code points up to U+10FFFF');
                }
                buf8[bufLen++] = (code >>> 18) + 0xF0;
                buf8[bufLen++] = (code >>> 12 & 0x3F) | 0x80;
                buf8[bufLen++] = (code >>> 6 & 0x3F) | 0x80;
                buf8[bufLen++] = (code & 0x3F) | 0x80;
            }
            if (bufLen >= 64) {
                this._dataLength += 64;
                YXDataSDK._md5cycle(this._state, buf32);
                bufLen -= 64;
                buf32[0] = buf32[16];
            }
        }
        this._bufferLength = bufLen;
        return this;
    }

    /**
     * Append an ASCII string to the hash buffer
     * @param str String to append
     */
    private appendAsciiStr(str: string) {
        const buf8 = this._buffer8;
        const buf32 = this._buffer32;
        let bufLen = this._bufferLength;
        let i;
        let j = 0;

        for (; ;) {
            i = Math.min(str.length - j, 64 - bufLen);
            while (i--) {
                buf8[bufLen++] = str.charCodeAt(j++);
            }
            if (bufLen < 64) {
                break;
            }
            this._dataLength += 64;
            YXDataSDK._md5cycle(this._state, buf32);
            bufLen = 0;
        }
        this._bufferLength = bufLen;
        return this;
    }

    /**
     * Append a byte array to the hash buffer
     * @param input array to append
     */
    private appendByteArray(input: Uint8Array) {
        const buf8 = this._buffer8;
        const buf32 = this._buffer32;
        let bufLen = this._bufferLength;
        let i;
        let j = 0;

        for (; ;) {
            i = Math.min(input.length - j, 64 - bufLen);
            while (i--) {
                buf8[bufLen++] = input[j++];
            }
            if (bufLen < 64) {
                break;
            }
            this._dataLength += 64;
            YXDataSDK._md5cycle(this._state, buf32);
            bufLen = 0;
        }
        this._bufferLength = bufLen;
        return this;
    }

    /**
     * Get the state of the hash buffer
     */
    private getState(): HasherState {
        const s = this._state;

        return {
            buffer: String.fromCharCode.apply(null, Array.from(this._buffer8)),
            buflen: this._bufferLength,
            length: this._dataLength,
            state: [s[0], s[1], s[2], s[3]]
        };
    }

    /**
     * Override the current state of the hash buffer
     * @param state New hash buffer state
     */
    private setState(state: HasherState) {
        const buf = state.buffer;
        const x = state.state;
        const s = this._state;
        let i;

        this._dataLength = state.length;
        this._bufferLength = state.buflen;
        s[0] = x[0];
        s[1] = x[1];
        s[2] = x[2];
        s[3] = x[3];

        for (i = 0; i < buf.length; i += 1) {
            this._buffer8[i] = buf.charCodeAt(i);
        }
    }

    /**
     * Hash the current state of the hash buffer and return the result
     * @param raw Whether to return the value as an `Int32Array`
     */
    private end(raw: boolean = false) {
        const bufLen = this._bufferLength;
        const buf8 = this._buffer8;
        const buf32 = this._buffer32;
        const i = (bufLen >> 2) + 1;

        this._dataLength += bufLen;
        const dataBitsLen = this._dataLength * 8

        buf8[bufLen] = 0x80;
        buf8[bufLen + 1] = buf8[bufLen + 2] = buf8[bufLen + 3] = 0;
        buf32.set(YXDataSDK.buffer32Identity.subarray(i), i);

        if (bufLen > 55) {
            YXDataSDK._md5cycle(this._state, buf32);
            buf32.set(YXDataSDK.buffer32Identity);
        }

        // Do the final computation based on the tail and length
        // Beware that the final length may not fit in 32 bits so we take care of that
        if (dataBitsLen <= 0xFFFFFFFF) {
            buf32[14] = dataBitsLen;
        } else {
            const matches = dataBitsLen.toString(16).match(/(.*?)(.{0,8})$/);
            if (matches === null) {
                return;
            }

            const lo = parseInt(matches[2], 16);
            const hi = parseInt(matches[1], 16) || 0;

            buf32[14] = lo;
            buf32[15] = hi;
        }

        YXDataSDK._md5cycle(this._state, buf32);

        return raw ? this._state : YXDataSDK._hex(this._state);
    }

}

interface HasherState {
    buffer: string;
    buflen: number;
    length: number;
    state: number[];
};