/*
    涌现数据SDK ts接口
    Example:
        console.log('DeviceId:', YXDataSDK.getDeviceId());
*/
declare class YXDataSDK {

    // 获取设备号
    static setDeviceId(device_id: string): string;

    // 设置设备号
    static getDeviceId(): string;

    // 初始化
    static init(config: {
        appid: string,                      // 项目APP ID
        app_server?: string                 // 服务器标识，单一服可传空值
        bConsoleLog?: boolean               // 默认(false), true表示debug需要输出控制台console日志
    }): Promise<any>;

    // 设置账号 ID
    static login(account_id: string): Promise<any>;
    // 设置公共事件属性

    static setSuperProperties(params: {
        [key: string]: any                  //属性键以字母开头、可包含数字、字母和下划线 "*"，长度最大为 50 个字符
    }): Promise<any>;

    // 删除单个公共事件属性
    static delSuperPropertyByName(key_name: string): Promise<any>;

    // 删除所有公共事件属性
    static delAllSuperProperties(): Promise<any>;

    // 发送事件
    static eventReport(data: {
        event_name: string,                 // 事件名称
        properties?: any,                   // 自定义事件属性
        is_first_event?: boolean,           //是否首次事件，true=首次事件
    }): Promise<any>;

    // 服务器标识，单一服可传空值
    static setAppServer(app_server: string): Promise<any>;

    // 配置用户属性(设置、修改)(替代setAccountProperty、changeAccountProperty、setAccountOnce接口)
    static configAccountProperty(params: {
        name: string,                       // 用户属性名称（允许字符：英文字母及下划线,长度为最大 50 个字符）
        value: any,                         // 属性值(值允许类型：数值、字符串、布尔、列表、浮点数、对象、对象组)
        opt?: number,                       // 1:设置属性(默认)、2=修改值、3:属性值存在则忽略
    }): Promise<any>;
	
	// 批量配置用户属性(替代configAccountProperty接口)
    static batConfigAccountProperty(params: {
        [key: string]: any                  //属性键以字母开头、可包含数字、字母和下划线 "*"，长度最大为 50 个字符
    }): Promise<any>;

    /**
     * 以下的接口即将废弃，请使用新的接口
     */
    // 首次事件(废弃，使用eventReport接口加is_first_event属性进行替代)
    static eventFirst(data: {
        event_name: string;                 // 事件名称
        properties?: any;                   // 自定义事件属性
    }): Promise<any>;

    // 设置增加用户属性(即将废弃)
    static setAccountProperty(params: {
        param_name: string,                 // 用户属性名称（允许字符：英文字母及下划线）
        param_type: number,                 // 属性类型(1=数值、2=字符串、4=布尔、5=列表、6=浮点数、7=对象、8=对象组)
        param_value: string,                // 属性值
    }): Promise<any>;

    // 修改用户属性值(即将废弃)
    static changeAccountProperty(params: {
        param_name: string,                 // 需属性名称
        param_value: string,                // 属性值
        add_sub: number,                    // 修改类型(0=覆盖、1=添加、2=减少)
    }): Promise<any>;

    // 设置用户属性（有值存在忽略操作）(即将废弃)
    static setAccountOnce(params: {
        param_name: string,                 // 用户属性名称（允许字符：英文字母及下划线）
        param_type: number,                 // 属性类型(1=数值、2=字符串、4=布尔、5=列表、6=浮点数、7=对象、8=对象组)
        param_value: string,                // 属性值
    }): Promise<any>;
}

// CommonJS 导出
export = YXDataSDK;

// ES Module 默认导出
declare namespace YXDataSDKNamespace {
    export { YXDataSDK };
}
export as namespace YXDataSDK;
export default YXDataSDKNamespace.YXDataSDK;