/*
    涌现数据SDK 多实例模式接口
    Example:
        console.log('DeviceId:', YXDataMoreSDK.getInstance('your_appid').getDeviceId());
*/

declare class YXDataMoreSDK {
    static getInstance(appid?: string): YXDataMoreSDK;
    
    // 获取设备号
    setDeviceId(device_id: string): string;

    // 设置设备号
    getDeviceId(): string;

    // 初始化
    init(config: {
        appid: string,                      // 项目APP ID
        app_server?: string                 // 服务器标识，单一服可传空值
        bConsoleLog?: boolean               // 已废弃
        app_secret?: string                 // 已废弃
    }): Promise<any>;

    // 设置账号 ID
    login(
        account_id: string
    ): Promise<any>;
    // 设置公共事件属性

    setSuperProperties(params: {
        [key: string]: any                  //属性键以字母开头、可包含数字、字母和下划线 "*"，长度最大为 50 个字符
    }): Promise<any>;

    // 删除单个公共事件属性
    delSuperPropertyByName(key_name: string): Promise<any>;

    // 删除所有公共事件属性
    delAllSuperProperties(): Promise<any>;

    // 发送事件
    eventReport(data: {
        event_name: string,                 // 事件名称
        properties?: any,                   // 自定义事件属性
        is_first_event?: boolean,           //是否首次事件，true=首次事件
    }): Promise<any>;

    // 服务器标识，单一服可传空值
    setAppServer(app_server: string): Promise<any>;

    // 配置用户属性(设置、修改)(替代setAccountProperty、changeAccountProperty、setAccountOnce接口)
     configAccountProperty(params: {
        name: string,                       // 用户属性名称（允许字符：英文字母及下划线,长度为最大 50 个字符）
        value: any,                         // 属性值(值允许类型：数值、字符串、布尔、列表、浮点数、对象、对象组)
        opt?: number,                       // 1:设置属性(默认)、2=修改值、3:属性值存在则忽略
    }): Promise<any>;

    // 批量配置用户属性(替代configAccountProperty接口)
    batConfigAccountProperty(params: {
        [key: string]: any                  //属性键以字母开头、可包含数字、字母和下划线 "*"，长度最大为 50 个字符
    }): Promise<any>;

    
    // 启动在线时长上报
    startingOnline(): Promise<any>;
    // 停止在线时长上报
    stopOnline(): Promise<any>;

    /**
     * 以下的接口即将废弃，请使用新的接口
     */
    // 首次事件(废弃，使用eventReport接口加is_first_event属性进行替代)
    eventFirst(data: {
        event_name: string;                 // 事件名称
        properties?: any;                   // 自定义事件属性
    }): Promise<any>;

    // 设置增加用户属性(即将废弃)
    setAccountProperty(params: {
        param_name: string,                 // 用户属性名称（允许字符：英文字母及下划线）
        param_type: number,                 // 属性类型(1=数值、2=字符串、4=布尔、5=列表、6=浮点数、7=对象、8=对象组)
        param_value: string,                // 属性值
    }): Promise<any>;

    // 修改用户属性值(即将废弃)
    changeAccountProperty(params: {
        param_name: string,                 // 需属性名称
        param_value: string,                // 属性值
        add_sub: number,                    // 修改类型(0=覆盖、1=添加、2=减少)
    }): Promise<any>;

    // 设置用户属性（有值存在忽略操作）(即将废弃)
    setAccountOnce(params: {
        param_name: string,                 // 用户属性名称（允许字符：英文字母及下划线）
        param_type: number,                 // 属性类型(1=数值、2=字符串、4=布尔、5=列表、6=浮点数、7=对象、8=对象组)
        param_value: string,                // 属性值
    }): Promise<any>;


}